package game;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;

import javax.swing.JFrame;
import javax.swing.JOptionPane;


public class PonyTestDriver  {
	private static PonyPanel theGame;
	private static JFrame theFrame = null;
	
	public static void main(String [] args) {
		
//		System.out.println("The Snag game is started.");
		
//		BusyPanel.primeThePump();
		
//		try {
//			Socket s = new Socket("localhost", 43253);
//			s.getInputStream();
//			s.getOutputStream();
//			
//			s.close();
//		} catch (UnknownHostException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		} catch (IOException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		}
		
		
		try {
			
			theFrame = new JFrame();
			
			BusyPanel.showWaitBox(BusyPanel.PREPARE, theFrame);
			
			theFrame.setSize(PonyPanel.PLAY_AREA_WIDTH + 16 , 600 + 38);
			
			theGame = new PonyPanel(theFrame);
			
			theFrame.addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e) {
					theGame.windowWasClosed();
				}
			});
			
			theFrame.setContentPane(theGame);

			ActionListener newGameLevel1Listener = new ActionListener() {
				public void actionPerformed(ActionEvent ae) {
					theGame.setStartingLevel(1);
					theGame.newGame();
				}
			};
			
			ActionListener newGameLevel5Listener = new ActionListener() {
				public void actionPerformed(ActionEvent ae) {
					theGame.setStartingLevel(5);
					theGame.newGame();
				}
			};
			
			ActionListener newGameLevel10Listener = new ActionListener() {
				public void actionPerformed(ActionEvent ae) {
					theGame.setStartingLevel(10);
					theGame.newGame();
				}
			};
			
			ActionListener newGameLevelSelectListener = new ActionListener() {
				public void actionPerformed(ActionEvent ae) {
					
					String levelStr = null;
					
					int startingLevel = -1;
					
					while(startingLevel < 0) {
						
						levelStr = JOptionPane.showInputDialog(theFrame, "Please enter which level you want to start on:", "Level Select", JOptionPane.QUESTION_MESSAGE);
						if(levelStr == null)
							return;
						
						try {
							startingLevel = Integer.parseInt(levelStr);
						} catch(NumberFormatException e) {
//							JOptionPane.showMessageDialog(theFrame, "Please enter a positive whole number.", "Error", JOptionPane.ERROR_MESSAGE);
						}
						
						if(startingLevel < 0) {
							JOptionPane.showMessageDialog(theFrame, "Please enter a positive whole number.", "Error", JOptionPane.ERROR_MESSAGE);
						}
						
						
					}
					
					theGame.setStartingLevel(startingLevel);
					theGame.newGame();
				}
			};
			
			ActionListener pauseGameListener = new ActionListener() {
				public void actionPerformed(ActionEvent ae) {
					theGame.togglePauseGame();
				}
			};
			
			ActionListener exitGameListener = new ActionListener() {
				public void actionPerformed(ActionEvent ae) {
					theGame.exitGame();
				}
			};
			
//			JMenuBar menuBar = new JMenuBar();
//			JMenu gameMenu = new JMenu("Game");
//			
//			
//			
//			JMenuItem pauseGameMenuItem = new JMenuItem("Pause");
//			pauseGameMenuItem.addActionListener(pauseGameListener);
//			gameMenu.add(pauseGameMenuItem);
//			
//			gameMenu.addSeparator();
//			
//			JMenuItem exitGameMenuItem = new JMenuItem("Quit");
//			exitGameMenuItem.addActionListener(exitGameListener);
//			gameMenu.add(exitGameMenuItem);
//			
//			menuBar.add(gameMenu);
//			
//			
//			
//			
//			
//			theFrame.setJMenuBar(menuBar);
			
			theFrame.addWindowListener(new WindowAdapter() {
				
				
				
				@Override
				public void windowClosed(WindowEvent arg0) {
					System.exit(0);
				}
				
				
			});
			
			theFrame.setVisible(true);
		
			
			theGame.gameStart();
		} catch(Throwable t) {
			
			String trace = PonyPanel.formatStackTrace(t);
			JOptionPane.showMessageDialog(null, t.getCause() + "\n" + t.getMessage() + "\n" + trace);
		}
		
	}
}
